package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aEstadoPeticion;
import com.ejie.ab18a.utils.Utilidades;

/**
 * Ab18a11s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aEstadoPeticionDaoImpl implements Ab18aEstadoPeticionDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aEstadoPeticion> rwMap = new RowMapper<Ab18aEstadoPeticion>() {
		public Ab18aEstadoPeticion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstadoPeticion(resultSet.getLong("T11IDESTADO"), resultSet.getString("T11DESCESTADO"));
		}
	};

	private RowMapper<Ab18aEstadoPeticion> rwMapAll = new RowMapper<Ab18aEstadoPeticion>() {
		public Ab18aEstadoPeticion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstadoPeticion(resultSet.getLong("T11IDESTADO"), resultSet.getString("T11DESCESTADO"),
					resultSet.getString("T11CODESTADO"));
		}
	};

	private RowMapper<Ab18aEstadoPeticion> rwMapPK = new RowMapper<Ab18aEstadoPeticion>() {
		public Ab18aEstadoPeticion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ab18aEstadoPeticion(resultSet.getLong("T11IDESTADO"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aEstadoPeticion>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aEstadoPeticion>>() {
		public JerarquiaDto<Ab18aEstadoPeticion> mapRow(ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aEstadoPeticion ab18a11s00 = new Ab18aEstadoPeticion(resultSet.getLong("T11IDESTADO"), resultSet.getString("T11DESCESTADO"));

			JerarquiaDto<Ab18aEstadoPeticion> jerarquia = new JerarquiaDto<Ab18aEstadoPeticion>();
			jerarquia.setModel(ab18a11s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @return Ab18a11s00
	 */
	public Ab18aEstadoPeticion add(Ab18aEstadoPeticion ab18a11s00) {
		String query = "INSERT INTO AB18A11S00 (T11_ID_ESTADO, T11_DESC_ESTADO, T11_COD_ESTADO) VALUES (?,?,?)";
		this.jdbcTemplate.update(query, ab18a11s00.getT11IdEstado(), ab18a11s00.getT11DescEstado(), ab18a11s00.getT11CodEstado());
		return ab18a11s00;
	}

	/**
	 * Updates a single row in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @return Ab18a11s00
	 */
	public Ab18aEstadoPeticion update(Ab18aEstadoPeticion ab18a11s00) {
		String query = "UPDATE AB18A11S00 SET T11_DESC_ESTADO=? WHERE T11_ID_ESTADO=?";
		this.jdbcTemplate.update(query, ab18a11s00.getT11DescEstado(), ab18a11s00.getT11IdEstado());
		return ab18a11s00;
	}

	/**
	 * Finds a single row in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @return Ab18a11s00
	 */
	@Transactional(readOnly = true)
	public Ab18aEstadoPeticion find(Ab18aEstadoPeticion ab18a11s00) {
		String query = "SELECT t1.T11_ID_ESTADO T11IDESTADO, t1.T11_DESC_ESTADO T11DESCESTADO FROM AB18A11S00 t1  WHERE t1.T11_ID_ESTADO = ?  ";

		List<Ab18aEstadoPeticion> ab18a11s00List = this.jdbcTemplate.query(query, this.rwMap, ab18a11s00.getT11IdEstado());
		return (Ab18aEstadoPeticion) DataAccessUtils.uniqueResult(ab18a11s00List);
	}

	/**
	 * Removes a single row in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @return
	 */
	public void remove(Ab18aEstadoPeticion ab18a11s00) {
		String query = "DELETE FROM AB18A11S00 WHERE T11_ID_ESTADO=?";
		this.jdbcTemplate.update(query, ab18a11s00.getT11IdEstado());
	}

	/**
	 * Finds a list of rows in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a11s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEstadoPeticion> findAll(Ab18aEstadoPeticion ab18a11s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO, t1.T11_COD_ESTADO T11CODESTADO ");
		query.append("FROM AB18A11S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a11s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEstadoPeticion>) this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a11s00 table using like.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a11s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aEstadoPeticion> findAllLike(Ab18aEstadoPeticion ab18a11s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO, t1.T11_COD_ESTADO T11CODESTADO ");
		query.append("FROM AB18A11S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a11s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aEstadoPeticion>) this.jdbcTemplate.query(query.toString(), this.rwMapAll, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a11s00 table.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aEstadoPeticion ab18a11s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A11S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a11s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Counts rows in the Ab18a11s00 table using like.
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aEstadoPeticion ab18a11s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A11S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a11s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a11s00 selected for rup_table
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a11s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEstadoPeticion>> reorderSelection(Ab18aEstadoPeticion ab18a11s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO ");
		// FROM
		query.append("FROM AB18A11S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a11s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(query, jqGridRequestDto, Ab18aEstadoPeticion.class, filterParamList,
				"T11_ID_ESTADO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aEstadoPeticion>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a11s00
	 * @param searchParams
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a11s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEstadoPeticion>> search(Ab18aEstadoPeticion filterParams, Ab18aEstadoPeticion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO ");
		// FROM
		query.append("FROM AB18A11S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Ab18aEstadoPeticion.class, filterParamList,
				searchSQL, searchParamList, from_alias, "T11_ID_ESTADO");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Ab18aEstadoPeticion>(this.rwMapPK,
				jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aEstadoPeticion filterab18a11s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO ");
		// FROM
		query.append("FROM AB18A11S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a11s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Ab18aEstadoPeticion.class, query, params,
				"T11_ID_ESTADO");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a11s00 table.
	 * 
	 * @param filterAb18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a11s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aEstadoPeticion>> findAllLikeJerarquia(Ab18aEstadoPeticion filterAb18a11s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T11_ID_ESTADO T11IDESTADO,t1.T11_DESC_ESTADO T11DESCESTADO ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A11S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A11S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a11s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "T11_ID_ESTADO", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aEstadoPeticion filterAb18a11s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A11S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A11S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a11s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "T11_ID_ESTADO", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a11s00
	 *            Ab18a11s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a11s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aEstadoPeticion>> findAllChild(Ab18aEstadoPeticion filterAb18a11s00, JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new StringBuilder("FROM AB18A11S00 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A11S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb18a11s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "T11_ID_ESTADO", "ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Ab18aEstadoPeticion>(this.rwMapPK, "T11_ID_ESTADO"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a11s00 entity
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aEstadoPeticion ab18a11s00) {

		StringBuilder where = new StringBuilder(Ab18aEstadoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (Utilidades.notNullAndNotEmpty(ab18a11s00.getT11IdEstado())) {
			where.append(" AND t1.T11_ID_ESTADO = ?");
			params.add(ab18a11s00.getT11IdEstado());
		}
		if (Utilidades.notNullAndNotEmpty(ab18a11s00.getT11DescEstado())) {
			where.append(" AND t1.T11_DESC_ESTADO = ?");
			params.add(ab18a11s00.getT11DescEstado());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a11s00 entity
	 * 
	 * @param ab18a11s00
	 *            Ab18a11s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aEstadoPeticion ab18a11s00, Boolean startsWith) {

		StringBuilder where = new StringBuilder(Ab18aEstadoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a11s00 != null && Utilidades.notNullAndNotEmpty(ab18a11s00.getT11IdEstado())) {
			where.append(" AND t1.T11_ID_ESTADO = ?");
			params.add(ab18a11s00.getT11IdEstado());
		}
		if (ab18a11s00 != null && Utilidades.notNullAndNotEmpty(ab18a11s00.getT11DescEstado())) {
			where.append(" AND UPPER(t1.T11_DESC_ESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a11s00.getT11DescEstado().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(ab18a11s00.getT11DescEstado().toUpperCase()) + "%");
			}
			where.append(" AND t1.T11_DESC_ESTADO IS NOT NULL");
		}

		if (ab18a11s00 != null && Utilidades.notNullAndNotEmpty(ab18a11s00.getT11CodEstado())) {
			where.append(" AND UPPER(t1.T11_COD_ESTADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a11s00.getT11CodEstado().toUpperCase() + "%");
			} else {
				params.add("%" + Utilidades.filtroLikeCaracterEspecial(ab18a11s00.getT11CodEstado().toUpperCase()) + "%");
			}
			where.append(" AND t1.T11_COD_ESTADO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	@Transactional(readOnly = true)
	public long findEstadoByCod(String codEnvio) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB18A11S00 t1 ");

		// Where clause & Params
		StringBuilder whereBuilder = new StringBuilder(Ab18aTipoPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		whereBuilder.append(" AND UPPER(t1.T11_COD_ESTADO) = ?");
		params.add(codEnvio.toUpperCase());

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(whereBuilder);
		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
}
